#--------------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.7
#---------------------------------------------------------------------------------------#
start.time <- proc.time()[3]

Method <- c(rep('Present',6), rep('New', 6))
Vial <- seq(1, 12, 1)
Protein <- c(0.426, 0.456, 0.454, 0.444, 0.456, 0.440, 
             0.449, 0.476, 0.467, 0.452, 0.473, 0.461)

table216DS <- data.frame(Method = as.factor(Method), Vial, Protein)

#---       Section 2.7.1       ---#
t.test(Protein~Method,data = table216DS, var.equal = TRUE)
t.test(Protein~Method,data = table216DS, var.equal = FALSE)


#---  Section 2.7.2       ---#
library(MBESS)
p.m <- aggregate(table216DS$Protein, by = list(table216DS$Method), mean ) 
p.v  <- aggregate(table216DS$Protein, by = list(table216DS$Method), var )
p.n <-  aggregate(table216DS$Protein, by = list(table216DS$Method), length )

pooled.v <- ((p.n[1,2] - 1)*p.v[1,2] + (p.n[2,2] - 1)*p.v[2,2])/(sum(p.n[,2])-2)
dm <- p.m[1,2] - p.m[2,2]
sdm <- dm/sqrt(pooled.v)
ci.smd(smd = -sdm, n.1 = p.n[1,2], n.2 = p.n[2,2], conf.level = 0.95)

#---   Fiducial GCI    method    ---#
set.seed(1234)
gsample <- 1e4

df1 <- p.n[1, 2] -1;   df2 <- p.n[2, 2] -1
z.gci <- rnorm(gsample)
w1.gci <- rchisq(gsample, df1)
w2.gci <- rchisq(gsample, df2)
w3.gci <- rchisq(gsample, df1)
#w3.gci <- w2.gci

es1.gci <- -dm - z.gci*sqrt((df2*p.v[2, 2])/(p.n[2,2]*w2.gci) + (df1*p.v[1, 2])/(p.n[1,2]*w1.gci)) 
es2.gci <- sqrt(df1*p.v[1, 2]/w3.gci)

es.gci <- es1.gci/es2.gci

ci.smd.gci <- quantile(es.gci, c(0.025, 0.975))
ci.smd.gci
summary(es.gci)

#---       Section 2.7.3       ---#
ratio <- var.test(Protein~Method, data= table216DS)
ratio$conf.int
1/ratio$estimate
1/ratio$conf.int

#  Section 2.8      ---#
diff <- t.test(Protein~Method, data = table216DS, paired=TRUE)
-1*diff$conf.int

#   Section 2.10
library(equivalence)

cpresent <- table216DS[table216DS$Method=="Present",]$Protein
cnew <- table216DS[table216DS$Method=="New",]$Protein
tost(x= cpresent, y= cnew, alpha=0.05, epsilon=-0.03, paired=TRUE)

cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600, "\n")
rm(list=ls(all=TRUE))

#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#